/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.settings;

import java.util.Objects;
import java.util.Set;
import jdk.jfr.BooleanFlag;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.settings.BooleanValue;

@MetadataDefinition
@Label(value="Enabled")
@Description(value="Record event")
@Name(value="jdk.settings.Enabled")
@BooleanFlag
public final class EnabledSetting
extends Control {
    private final BooleanValue booleanValue;
    private final PlatformEventType eventType;

    public EnabledSetting(PlatformEventType eventType, String defaultValue) {
        super(defaultValue);
        this.booleanValue = BooleanValue.valueOf(defaultValue);
        this.eventType = Objects.requireNonNull(eventType);
    }

    @Override
    public String combine(Set<String> values) {
        return this.booleanValue.union(values);
    }

    @Override
    public void setValue(String value) {
        this.booleanValue.setValue(value);
        this.eventType.setEnabled(this.booleanValue.getBoolean());
        if (this.eventType.isEnabled() && !this.eventType.isJVM() && !this.eventType.isInstrumented()) {
            this.eventType.markForInstrumentation(true);
        }
    }

    @Override
    public String getValue() {
        return this.booleanValue.getValue();
    }
}

