/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Enabled;
import jdk.jfr.Event;
import jdk.jfr.Name;
import jdk.jfr.Period;
import jdk.jfr.SettingControl;
import jdk.jfr.SettingDefinition;
import jdk.jfr.StackTrace;
import jdk.jfr.Threshold;
import jdk.jfr.events.ActiveSettingEvent;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.Cutoff;
import jdk.jfr.internal.EventInstrumentation;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.TypeLibrary;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.settings.CutoffSetting;
import jdk.jfr.internal.settings.EnabledSetting;
import jdk.jfr.internal.settings.PeriodSetting;
import jdk.jfr.internal.settings.StackTraceSetting;
import jdk.jfr.internal.settings.ThresholdSetting;

public final class EventControl {
    static final String FIELD_SETTING_PREFIX = "setting";
    private static final Type TYPE_ENABLED = TypeLibrary.createType(EnabledSetting.class);
    private static final Type TYPE_THRESHOLD = TypeLibrary.createType(ThresholdSetting.class);
    private static final Type TYPE_STACK_TRACE = TypeLibrary.createType(StackTraceSetting.class);
    private static final Type TYPE_PERIOD = TypeLibrary.createType(PeriodSetting.class);
    private static final Type TYPE_CUTOFF = TypeLibrary.createType(CutoffSetting.class);
    private final List<EventInstrumentation.SettingInfo> settingInfos = new ArrayList<EventInstrumentation.SettingInfo>();
    private final Map<String, Control> eventControls = new HashMap<String, Control>(5);
    private final PlatformEventType type;
    private final String idName;

    EventControl(PlatformEventType eventType) {
        this.eventControls.put("enabled", EventControl.defineEnabled(eventType));
        if (eventType.hasDuration()) {
            this.eventControls.put("threshold", EventControl.defineThreshold(eventType));
        }
        if (eventType.hasStackTrace()) {
            this.eventControls.put("stackTrace", EventControl.defineStackTrace(eventType));
        }
        if (eventType.hasPeriod()) {
            this.eventControls.put("period", EventControl.definePeriod(eventType));
        }
        if (eventType.hasCutoff()) {
            this.eventControls.put("cutoff", EventControl.defineCutoff(eventType));
        }
        ArrayList<AnnotationElement> aes = new ArrayList<AnnotationElement>(eventType.getAnnotationElements());
        EventControl.remove(eventType, aes, Threshold.class);
        EventControl.remove(eventType, aes, Period.class);
        EventControl.remove(eventType, aes, Enabled.class);
        EventControl.remove(eventType, aes, StackTrace.class);
        EventControl.remove(eventType, aes, Cutoff.class);
        aes.trimToSize();
        eventType.setAnnotations(aes);
        this.type = eventType;
        this.idName = String.valueOf(eventType.getId());
    }

    static void remove(PlatformEventType type, List<AnnotationElement> aes, Class<? extends Annotation> clazz) {
        long id = Type.getTypeId(clazz);
        for (AnnotationElement a : type.getAnnotationElements()) {
            if (a.getTypeId() != id || !a.getTypeName().equals(clazz.getName())) continue;
            aes.remove(a);
        }
    }

    EventControl(PlatformEventType es, Class<? extends Event> eventClass) {
        this(es);
        this.defineSettings(eventClass);
    }

    private void defineSettings(Class<?> eventClass) {
        boolean allowPrivateMethod = true;
        while (eventClass != null) {
            for (Method m : eventClass.getDeclaredMethods()) {
                Class<?> settingClass;
                SettingDefinition se;
                boolean isPrivate = Modifier.isPrivate(m.getModifiers());
                if (m.getReturnType() != Boolean.TYPE || m.getParameterCount() != 1 || isPrivate && !allowPrivateMethod || (se = m.getDeclaredAnnotation(SettingDefinition.class)) == null || Modifier.isAbstract((settingClass = m.getParameters()[0].getType()).getModifiers()) || !SettingControl.class.isAssignableFrom(settingClass)) continue;
                String name = m.getName();
                Name n = m.getAnnotation(Name.class);
                if (n != null) {
                    name = n.value();
                }
                if (this.eventControls.containsKey(name)) continue;
                this.defineSetting(settingClass, m, this.type, name);
            }
            eventClass = eventClass.getSuperclass();
            allowPrivateMethod = false;
        }
    }

    private void defineSetting(Class<? extends SettingControl> settingsClass, Method method, PlatformEventType eventType, String settingName) {
        try {
            int index = this.settingInfos.size();
            EventInstrumentation.SettingInfo si = new EventInstrumentation.SettingInfo(FIELD_SETTING_PREFIX + index, index);
            SettingControl c = si.settingControl = this.instantiateSettingControl(settingsClass);
            c.setDefault();
            String defaultValue = c.getValueSafe();
            if (defaultValue != null) {
                Type settingType = TypeLibrary.createType(settingsClass);
                ArrayList<AnnotationElement> aes = new ArrayList<AnnotationElement>();
                for (Annotation a : method.getDeclaredAnnotations()) {
                    AnnotationElement ae = TypeLibrary.createAnnotation(a);
                    if (ae == null) continue;
                    aes.add(ae);
                }
                aes.trimToSize();
                this.eventControls.put(settingName, si.settingControl);
                eventType.add(PrivateAccess.getInstance().newSettingDescriptor(settingType, settingName, defaultValue, aes));
                this.settingInfos.add(si);
            }
        }
        catch (InstantiationException e) {
            throw new InstantiationError("Could not instantiate setting " + settingsClass.getName() + " for event " + eventType.getLogName() + ". " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError("Could not access setting " + settingsClass.getName() + " for event " + eventType.getLogName() + ". " + e.getMessage());
        }
    }

    private SettingControl instantiateSettingControl(Class<? extends SettingControl> settingControlClass) throws IllegalAccessException, InstantiationException {
        Constructor<?> cc;
        SecuritySupport.makeVisibleToJFR(settingControlClass);
        try {
            cc = settingControlClass.getDeclaredConstructors()[0];
        }
        catch (Exception e) {
            throw (Error)new InternalError("Could not get constructor for " + settingControlClass.getName()).initCause(e);
        }
        SecuritySupport.setAccessible(cc);
        try {
            return (SettingControl)cc.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | InvocationTargetException e) {
            throw new InternalError("Could not instantiate setting for class " + settingControlClass.getName());
        }
    }

    private static Control defineEnabled(PlatformEventType type) {
        String def;
        Enabled enabled = (Enabled)type.getAnnotation(Enabled.class);
        String string = def = type.isJVM() ? "false" : "true";
        if (enabled != null) {
            def = Boolean.toString(enabled.value());
        }
        type.add(PrivateAccess.getInstance().newSettingDescriptor(TYPE_ENABLED, "enabled", def, Collections.emptyList()));
        return new EnabledSetting(type, def);
    }

    private static Control defineThreshold(PlatformEventType type) {
        Threshold threshold = (Threshold)type.getAnnotation(Threshold.class);
        String def = "0 ns";
        if (threshold != null) {
            def = threshold.value();
        }
        type.add(PrivateAccess.getInstance().newSettingDescriptor(TYPE_THRESHOLD, "threshold", def, Collections.emptyList()));
        return new ThresholdSetting(type, def);
    }

    private static Control defineStackTrace(PlatformEventType type) {
        StackTrace stackTrace = (StackTrace)type.getAnnotation(StackTrace.class);
        String def = "true";
        if (stackTrace != null) {
            def = Boolean.toString(stackTrace.value());
        }
        type.add(PrivateAccess.getInstance().newSettingDescriptor(TYPE_STACK_TRACE, "stackTrace", def, Collections.emptyList()));
        return new StackTraceSetting(type, def);
    }

    private static Control defineCutoff(PlatformEventType type) {
        Cutoff cutoff = (Cutoff)type.getAnnotation(Cutoff.class);
        String def = "infinity";
        if (cutoff != null) {
            def = cutoff.value();
        }
        type.add(PrivateAccess.getInstance().newSettingDescriptor(TYPE_CUTOFF, "cutoff", def, Collections.emptyList()));
        return new CutoffSetting(type, def);
    }

    private static Control definePeriod(PlatformEventType type) {
        Period period = (Period)type.getAnnotation(Period.class);
        String def = "everyChunk";
        if (period != null) {
            def = period.value();
        }
        type.add(PrivateAccess.getInstance().newSettingDescriptor(TYPE_PERIOD, "period", def, Collections.emptyList()));
        return new PeriodSetting(type, def);
    }

    void disable() {
        for (Control c : this.eventControls.values()) {
            if (!(c instanceof EnabledSetting)) continue;
            c.setValueSafe("false");
            return;
        }
    }

    void writeActiveSettingEvent() {
        if (!this.type.isRegistered()) {
            return;
        }
        for (Map.Entry<String, Control> entry : this.eventControls.entrySet()) {
            Control c = entry.getValue();
            if (!Utils.isSettingVisible(c, this.type.hasEventHook())) continue;
            String value = c.getLastValue();
            if (value == null) {
                value = c.getDefaultValue();
            }
            ActiveSettingEvent ase = new ActiveSettingEvent();
            ase.id = this.type.getId();
            ase.name = entry.getKey();
            ase.value = value;
            ase.commit();
        }
    }

    public Set<Map.Entry<String, Control>> getEntries() {
        return this.eventControls.entrySet();
    }

    public PlatformEventType getEventType() {
        return this.type;
    }

    public String getSettingsId() {
        return this.idName;
    }

    public List<EventInstrumentation.SettingInfo> getSettingInfos() {
        return this.settingInfos;
    }
}

