/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import jdk.jfr.Enabled;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Period;
import jdk.jfr.Registered;
import jdk.jfr.StackTrace;
import jdk.jfr.Threshold;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.TypeLibrary;
import jdk.jfr.internal.Utils;

public final class AnnotationElement {
    private final Type type;
    private final List<Object> annotationValues;
    private final List<String> annotationNames;
    private final boolean inBootClassLoader;

    /*
     * WARNING - void declaration
     */
    AnnotationElement(Type type, List<Object> objects, boolean boot) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(objects);
        this.type = type;
        if (objects.size() != type.getFields().size()) {
            StringJoiner descriptors = new StringJoiner(",", "[", "]");
            for (ValueDescriptor valueDescriptor : type.getFields()) {
                descriptors.add(valueDescriptor.getName());
            }
            StringJoiner values = new StringJoiner(",", "[", "]");
            for (Object object : objects) {
                descriptors.add(String.valueOf(object));
            }
            throw new IllegalArgumentException("Annotation " + descriptors + " for " + type.getName() + " doesn't match number of values " + values);
        }
        ArrayList<String> n = new ArrayList<String>();
        ArrayList<Object> v = new ArrayList<Object>();
        boolean bl = false;
        for (ValueDescriptor valueDescriptor : type.getFields()) {
            void var6_11;
            Object object = objects.get((int)var6_11);
            if (object == null) {
                throw new IllegalArgumentException("Annotation value can't be null");
            }
            Class<?> valueType = object.getClass();
            if (valueDescriptor.isArray()) {
                valueType = valueType.getComponentType();
            }
            AnnotationElement.checkType(Utils.unboxType(valueType));
            n.add(valueDescriptor.getName());
            v.add(object);
            ++var6_11;
        }
        this.annotationValues = Utils.smallUnmodifiable(v);
        this.annotationNames = Utils.smallUnmodifiable(n);
        this.inBootClassLoader = boot;
    }

    public AnnotationElement(Class<? extends Annotation> annotationType, Map<String, Object> values) {
        Objects.requireNonNull(annotationType);
        Objects.requireNonNull(values);
        Utils.checkRegisterPermission();
        HashMap<String, Object> map = new HashMap<String, Object>(values);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("Name of annotation method can't be null");
            }
            if (entry.getValue() != null) continue;
            throw new NullPointerException("Return value for annotation method can't be null");
        }
        if (AnnotationElement.class.isAssignableFrom(annotationType) && annotationType.isInterface()) {
            throw new IllegalArgumentException("Must be interface extending " + Annotation.class.getName());
        }
        if (!AnnotationElement.isKnownJFRAnnotation(annotationType) && annotationType.getAnnotation(MetadataDefinition.class) == null) {
            throw new IllegalArgumentException("Annotation class must be annotated with jdk.jfr.MetadataDefinition to be valid");
        }
        this.type = AnnotationElement.isKnownJFRAnnotation(annotationType) ? new Type(annotationType.getCanonicalName(), Type.SUPER_TYPE_ANNOTATION, Type.getTypeId(annotationType)) : TypeLibrary.createAnnotationType(annotationType);
        Method[] methods = annotationType.getDeclaredMethods();
        if (methods.length != map.size()) {
            throw new IllegalArgumentException("Number of declared methods must match size of value map");
        }
        ArrayList<String> n = new ArrayList<String>();
        ArrayList<Object> v = new ArrayList<Object>();
        HashSet nameSet = new HashSet();
        for (Method method : methods) {
            String fieldName = method.getName();
            Object object = map.get(fieldName);
            if (object == null) {
                throw new IllegalArgumentException("No method in annotation interface " + annotationType.getName() + " matching name " + fieldName);
            }
            Class<?> fieldType = object.getClass();
            if (fieldType == Class.class) {
                throw new IllegalArgumentException("Annotation value for " + fieldName + " can't be class");
            }
            if (object instanceof Enum) {
                throw new IllegalArgumentException("Annotation value for " + fieldName + " can't be enum");
            }
            if (!fieldType.equals(object.getClass())) {
                throw new IllegalArgumentException("Return type of annotation " + fieldType.getName() + " must match type of object" + object.getClass());
            }
            if (fieldType.isArray()) {
                Class<?> componentType = fieldType.getComponentType();
                AnnotationElement.checkType(componentType);
                if (componentType.equals(String.class)) {
                    String[] stringArray = (String[])object;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] != null) continue;
                        throw new IllegalArgumentException("Annotation value for " + fieldName + " contains null");
                    }
                }
            } else {
                fieldType = Utils.unboxType(object.getClass());
                AnnotationElement.checkType(fieldType);
            }
            if (nameSet.contains(fieldName)) {
                throw new IllegalArgumentException("Value with name '" + fieldName + "' already exists");
            }
            if (AnnotationElement.isKnownJFRAnnotation(annotationType)) {
                ValueDescriptor vd = new ValueDescriptor(fieldType, fieldName, Collections.emptyList(), true);
                this.type.add(vd);
            }
            n.add(fieldName);
            v.add(object);
        }
        this.annotationValues = Utils.smallUnmodifiable(v);
        this.annotationNames = Utils.smallUnmodifiable(n);
        this.inBootClassLoader = annotationType.getClassLoader() == null;
    }

    public AnnotationElement(Class<? extends Annotation> annotationType, Object value) {
        this(annotationType, Collections.singletonMap("value", Objects.requireNonNull(value)));
    }

    public AnnotationElement(Class<? extends Annotation> annotationType) {
        this(annotationType, Collections.emptyMap());
    }

    public List<Object> getValues() {
        return this.annotationValues;
    }

    public List<ValueDescriptor> getValueDescriptors() {
        return Collections.unmodifiableList(this.type.getFields());
    }

    public List<AnnotationElement> getAnnotationElements() {
        return this.type.getAnnotationElements();
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public Object getValue(String name) {
        Objects.requireNonNull(name);
        int index = 0;
        for (String n : this.annotationNames) {
            if (name.equals(n)) {
                return this.annotationValues.get(index);
            }
            ++index;
        }
        StringJoiner valueNames = new StringJoiner(",", "[", "]");
        for (ValueDescriptor v : this.type.getFields()) {
            valueNames.add(v.getName());
        }
        throw new IllegalArgumentException("No value with name '" + name + "'. Valid names are " + valueNames);
    }

    public boolean hasValue(String name) {
        Objects.requireNonNull(name);
        for (String n : this.annotationNames) {
            if (!name.equals(n)) continue;
            return true;
        }
        return false;
    }

    public final <A> A getAnnotation(Class<? extends Annotation> annotationType) {
        Objects.requireNonNull(annotationType);
        return (A)this.type.getAnnotation(annotationType);
    }

    public long getTypeId() {
        return this.type.getId();
    }

    Type getType() {
        return this.type;
    }

    private static void checkType(Class<?> type) {
        if (type.isPrimitive()) {
            return;
        }
        if (type == String.class) {
            return;
        }
        throw new IllegalArgumentException("Only primitives types or java.lang.String are allowed");
    }

    private static boolean isKnownJFRAnnotation(Class<? extends Annotation> annotationType) {
        if (annotationType == Registered.class) {
            return true;
        }
        if (annotationType == Threshold.class) {
            return true;
        }
        if (annotationType == StackTrace.class) {
            return true;
        }
        if (annotationType == Period.class) {
            return true;
        }
        return annotationType == Enabled.class;
    }

    boolean isInBoot() {
        return this.inBootClassLoader;
    }
}

